﻿
CREATE PROCEDURE [App].[NVCC_usp_GetAnnouncement]
	-- @active is a numeric parameter. If 1, only return the active announcements;
	-- if 0, return all announcements.
	@active int
AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_GetLogs
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 06-06-2016
--
--
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : To get selected announcements
--==================================================================================
--Uses: App.NVCC_Announcement
--Uses: App.NVCC_DimAnnouncement

BEGIN
	IF (@active = 0) 
		BEGIN
			SELECT
				A.AnnouncementID,
				DA.AnnouncementType,
				lc.LastName + ', ' + lc.FirstName AS Creator,
				A.CreationDT,
				A.ExpirationDT,
				A.Text
			FROM App.NVCC_Announcement AS A
				INNER JOIN App.NVCC_DimAnnouncement AS DA
					ON A.AnnouncementTypeID = DA.AnnouncementTypeID
				LEFT JOIN CDWWork.LCustomer.LCustomer lc
					ON A.Creator = lc.ADDomain + '\' + lc.ADLogin
		END
	ELSE IF (@active = 1)
		BEGIN
			SELECT
				A.AnnouncementID,
				DA.AnnouncementType,
				lc.LastName + ', ' + lc.FirstName AS Creator,
				A.CreationDT,
				A.ExpirationDT,
				A.Text
			FROM App.NVCC_Announcement AS A
				INNER JOIN App.NVCC_DimAnnouncement AS DA
					ON A.AnnouncementTypeID = DA.AnnouncementTypeID
				LEFT JOIN CDWWork.LCustomer.LCustomer lc
					ON A.Creator = lc.ADDomain + '\' + lc.ADLogin
			WHERE
				A.ExpirationDT >= GETUTCDATE() AND A.CreationDT <= GETUTCDATE()
		END
END

